/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.logging;

import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.MyMonitor;
import filenet.vw.base.logging.ResourcesAppender;
import java.util.Enumeration;
import org.apache.log4j.Appender;

public class SessionTracker {
    private static Object _syncObj = new Object();
    private static int nSessions = 0;
    private static final String RESOURCE_TRACING_NAME_LOGGER = "filenet.pe.rpc.resources.tracing";
    protected static Logger logger = Logger.getLogger("filenet.pe.rpc.resources.tracing");
    private static MyMonitor m_monitorThread = null;

    public static String _get_FILE_DATE() {
        return "$Date:   29 Jun 2007 12:19:12  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.2  $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AddRef() {
        Object object = _syncObj;
        synchronized (object) {
            ++nSessions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Release() {
        Object object = _syncObj;
        synchronized (object) {
            --nSessions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void SetInterval(int interval) {
        if (interval == 0) {
            SessionTracker.Stop();
        } else {
            if (m_monitorThread == null) {
                Object object = _syncObj;
                synchronized (object) {
                    if (m_monitorThread == null) {
                        m_monitorThread = new MyMonitor(interval);
                        m_monitorThread.start();
                    }
                }
            }
            Object object = _syncObj;
            synchronized (object) {
                m_monitorThread.setInterval(interval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void Stop() {
        Object object = _syncObj;
        synchronized (object) {
            if (m_monitorThread != null) {
                m_monitorThread.stopWork();
                m_monitorThread = null;
            }
        }
    }

    private static int GetPollingInterval() {
        Enumeration appenders = logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender a = (Appender)appenders.nextElement();
            if (!(a instanceof ResourcesAppender)) continue;
            return ((ResourcesAppender)a).getPollingInterval();
        }
        return 0;
    }

    protected static void Check() {
        if (!logger.isFinest()) {
            return;
        }
        SessionTracker.SetInterval(SessionTracker.GetPollingInterval());
    }

    protected static void DUMP() {
        if (!logger.isFinest()) {
            return;
        }
        Runtime r = Runtime.getRuntime();
        StringBuffer buf = new StringBuffer();
        buf.append("nSessions=").append(nSessions).append("\tnThreads=").append(Logger.CountThread()).append("\tfree=").append(r.freeMemory()).append("\ttotal=").append(r.totalMemory());
        logger.finest("SessionTracker", "ORB", buf.toString());
        SessionTracker.Check();
    }
}

